
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Set objective function
m.setObjective(5*strawberries + 1*apple_pies + 2*apples + 7*peanutbutter_sandwiches, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7*strawberries + 7*peanutbutter_sandwiches >= 94)
m.addConstr(18*apples + 7*peanutbutter_sandwiches >= 43)
m.addConstr(7*strawberries + 7*apple_pies + 18*apples >= 53)
m.addConstr(7*strawberries + 7*apple_pies + 18*apples + 7*peanutbutter_sandwiches >= 53)
m.addConstr(35*apple_pies + 12*apples >= 28)
m.addConstr(35*apple_pies + 23*peanutbutter_sandwiches >= 16)
m.addConstr(12*apples + 23*peanutbutter_sandwiches >= 28)
m.addConstr(18*strawberries + 23*peanutbutter_sandwiches >= 31)
m.addConstr(18*strawberries + 12*apples >= 38)
m.addConstr(35*apple_pies + 12*apples + 23*peanutbutter_sandwiches >= 35)
m.addConstr(18*strawberries + 35*apple_pies + 12*apples >= 35)
m.addConstr(18*strawberries + 35*apple_pies + 23*peanutbutter_sandwiches >= 35)
m.addConstr(18*strawberries + 12*apples + 23*peanutbutter_sandwiches >= 35)
m.addConstr(35*apple_pies + 12*apples + 23*peanutbutter_sandwiches >= 26)
m.addConstr(18*strawberries + 35*apple_pies + 12*apples >= 26)
m.addConstr(18*strawberries + 35*apple_pies + 23*peanutbutter_sandwiches >= 26)
m.addConstr(18*strawberries + 12*apples + 23*peanutbutter_sandwiches >= 26)
m.addConstr(35*apple_pies + 12*apples + 23*peanutbutter_sandwiches >= 23)
m.addConstr(18*strawberries + 35*apple_pies + 12*apples >= 23)
m.addConstr(18*strawberries + 35*apple_pies + 23*peanutbutter_sandwiches >= 23)
m.addConstr(18*strawberries + 12*apples + 23*peanutbutter_sandwiches >= 23)
m.addConstr(35*apple_pies + 12*apples + 23*peanutbutter_sandwiches >= 38)
m.addConstr(18*strawberries + 35*apple_pies + 12*apples >= 38)
m.addConstr(18*strawberries + 35*apple_pies + 23*peanutbutter_sandwiches >= 38)
m.addConstr(18*strawberries + 12*apples + 23*peanutbutter_sandwiches >= 38)
m.addConstr(18*strawberries + 35*apple_pies + 12*apples + 23*peanutbutter_sandwiches >= 38)
m.addConstr(-3*strawberries + 2*apple_pies >= 0)
m.addConstr(-1*apple_pies + 2*peanutbutter_sandwiches >= 0)
m.addConstr(18*apples + 7*peanutbutter_sandwiches <= 113)
m.addConstr(7*strawberries + 18*apples <= 144)
m.addConstr(7*strawberries + 18*apples + 7*peanutbutter_sandwiches <= 192)
m.addConstr(7*apple_pies + 18*apples + 7*peanutbutter_sandwiches <= 311)
m.addConstr(7*strawberries + 7*apple_pies + 18*apples <= 186)
m.addConstr(18*strawberries + 12*apples <= 88)

m.addConstr(7*strawberries + 7*apple_pies + 18*apples + 7*peanutbutter_sandwiches <= 421)
m.addConstr(18*strawberries + 35*apple_pies + 12*apples + 23*peanutbutter_sandwiches <= 190)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

