
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
strawberries = m.addVar(name="strawberries", lb=0)
apple_pies = m.addVar(name="apple_pies", lb=0)
apples = m.addVar(name="apples", lb=0)
peanutbutter_sandwiches = m.addVar(name="peanutbutter_sandwiches", lb=0)

# Define the objective function
m.setObjective(5 * strawberries + apple_pies + 2 * apples + 7 * peanutbutter_sandwiches, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * strawberries + 7 * peanutbutter_sandwiches >= 94)
m.addConstr(18 * apples + 7 * peanutbutter_sandwiches >= 43)
m.addConstr(7 * strawberries + 7 * apple_pies + 18 * apples >= 53)
m.addConstr(7 * strawberries + 7 * apple_pies + 18 * apples + 7 * peanutbutter_sandwiches >= 53)
m.addConstr(35 * apple_pies + 12 * apples >= 28)
m.addConstr(35 * apple_pies + 23 * peanutbutter_sandwiches >= 16)
m.addConstr(12 * apples + 23 * peanutbutter_sandwiches >= 28)
m.addConstr(18 * strawberries + 23 * peanutbutter_sandwiches >= 31)
m.addConstr(18 * strawberries + 12 * apples >= 38)
m.addConstr(35 * apple_pies + 12 * apples + 23 * peanutbutter_sandwiches >= 35)
m.addConstr(18 * strawberries + 35 * apple_pies + 12 * apples >= 35)
m.addConstr(18 * strawberries + 35 * apple_pies + 23 * peanutbutter_sandwiches >= 35)
m.addConstr(35 * apple_pies + 12 * apples + 23 * peanutbutter_sandwiches >= 26)
m.addConstr(18 * strawberries + 35 * apple_pies + 12 * apples >= 26)
m.addConstr(18 * strawberries + 35 * apple_pies + 23 * peanutbutter_sandwiches >= 26)
m.addConstr(18 * strawberries + 12 * apples + 23 * peanutbutter_sandwiches >= 26)
m.addConstr(35 * apple_pies + 12 * apples + 23 * peanutbutter_sandwiches >= 23)
m.addConstr(18 * strawberries + 35 * apple_pies + 12 * apples >= 23)
m.addConstr(18 * strawberries + 35 * apple_pies + 23 * peanutbutter_sandwiches >= 23)
m.addConstr(-3 * strawberries + 2 * apple_pies >= 0)
m.addConstr(-apple_pies + 2 * peanutbutter_sandwiches >= 0)
m.addConstr(18 * apples + 7 * peanutbutter_sandwiches <= 113)
m.addConstr(7 * strawberries + 18 * apples <= 144)
m.addConstr(7 * strawberries + 18 * apples + 7 * peanutbutter_sandwiches <= 192)
m.addConstr(7 * apple_pies + 18 * apples + 7 * peanutbutter_sandwiches <= 311)
m.addConstr(7 * strawberries + 7 * apple_pies + 18 * apples <= 186)
m.addConstr(18 * strawberries + 12 * apples <= 88)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Strawberries: ", strawberries.varValue)
    print("Apple Pies: ", apple_pies.varValue)
    print("Apples: ", apples.varValue)
    print("Peanutbutter Sandwiches: ", peanutbutter_sandwiches.varValue)
else:
    print("The model is infeasible")
