
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")


# Set objective function
m.setObjective(6 * george + 8 * mary + 2 * dale + 3 * paul + 1 * hank, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.27 * george + 2.96 * hank >= 101)
m.addConstr(1.27 * george + 2.38 * mary + 3.96 * paul >= 63)
m.addConstr(2.96 * dale + 3.96 * paul + 2.96 * hank >= 63)
m.addConstr(1.27 * george + 2.38 * mary + 3.96 * paul >= 56)
m.addConstr(2.96 * dale + 3.96 * paul + 2.96 * hank >= 56)
m.addConstr(1.07 * george + 2.59 * mary >= 32)
m.addConstr(2.59 * mary + 3.74 * dale >= 56)
m.addConstr(2.59 * mary + 1.4 * paul >= 27)
m.addConstr(1.07 * george + 3.23 * hank >= 30)
m.addConstr(2.59 * mary + 3.23 * hank >= 71)
m.addConstr(3.74 * dale + 1.4 * paul >= 30)
m.addConstr(1.4 * paul + 3.23 * hank >= 64)
m.addConstr(1.27 * george + 2.96 * hank <= 202)
m.addConstr(1.27 * george + 2.38 * mary <= 275)
m.addConstr(1.27 * george + 2.38 * mary + 2.96 * dale + 3.96 * paul + 2.96 * hank <= 275)
m.addConstr(1.07 * george + 2.59 * mary <= 227)
m.addConstr(1.07 * george + 3.23 * hank <= 254)
m.addConstr(2.59 * mary + 1.4 * paul <= 151)
m.addConstr(3.74 * dale + 1.4 * paul <= 348)
m.addConstr(1.07 * george + 2.59 * mary + 3.74 * dale <= 210)
m.addConstr(1.07 * george + 1.4 * paul + 3.23 * hank <= 328)
m.addConstr(1.07 * george + 2.59 * mary + 3.74 * dale + 1.4 * paul + 3.23 * hank <= 328)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

