
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(2*x0 + 4*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17*x1 + 2*x2 >= 17, "c0")
    model.addConstr(12*x0 + 2*x2 >= 15, "c1")
    model.addConstr(12*x0 + 17*x1 + 2*x2 >= 15, "c2")
    model.addConstr(15*x1 + 12*x2 >= 27, "c3")
    model.addConstr(4*x0 + 15*x1 + 12*x2 >= 27, "c4")
    model.addConstr(15*x0 + 13*x2 >= 28, "c5")
    model.addConstr(2*x1 + 13*x2 >= 26, "c6")
    model.addConstr(15*x0 + 2*x1 >= 31, "c7")
    model.addConstr(15*x0 + 2*x1 + 13*x2 >= 31, "c8")
    model.addConstr(12*x0 + 2*x1 >= 11, "c9")
    model.addConstr(12*x0 + 4*x2 >= 17, "c10")
    model.addConstr(12*x0 + 2*x1 + 4*x2 >= 17, "c11")
    model.addConstr(-4*x1 + 6*x2 >= 0, "c12")
    model.addConstr(6*x0 - 2*x1 >= 0, "c13")
    model.addConstr(6*x0 - 3*x2 >= 0, "c14")
    model.addConstr(15*x0 + 2*x1 <= 108, "c15")
    model.addConstr(2*x1 + 13*x2 <= 89, "c16")
    model.addConstr(15*x0 + 2*x1 + 13*x2 <= 43, "c17")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
