
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Dale", lb=0)
x1 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x2 = m.addVar(name="hours_worked_by_Jean", lb=0)

# Objective function
m.setObjective(2*x0 + 4*x1 + 5*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(12*x0 <= 73)
m.addConstr(4*x0 <= 105)
m.addConstr(15*x0 <= 117)
m.addConstr(12*x0 <= 81)
m.addConstr(17*x1 <= 73)
m.addConstr(15*x1 <= 105)
m.addConstr(2*x1 <= 117)
m.addConstr(2*x1 <= 81)
m.addConstr(2*x2 <= 73)
m.addConstr(12*x2 <= 105)
m.addConstr(13*x2 <= 117)
m.addConstr(4*x2 <= 81)
m.addConstr(17*x1 + 2*x2 >= 17)
m.addConstr(12*x0 + 2*x2 >= 15)
m.addConstr(12*x0 + 17*x1 + 2*x2 >= 15)
m.addConstr(15*x1 + 12*x2 >= 27)
m.addConstr(4*x0 + 15*x1 + 12*x2 >= 27)
m.addConstr(15*x0 + 13*x2 >= 28)
m.addConstr(2*x1 + 13*x2 >= 26)
m.addConstr(15*x0 + 2*x1 >= 31)
m.addConstr(15*x0 + 2*x1 + 13*x2 >= 31)
m.addConstr(12*x0 + 2*x1 >= 11)
m.addConstr(12*x0 + 4*x2 >= 17)
m.addConstr(12*x0 + 2*x1 + 4*x2 >= 17)
m.addConstr(-4*x1 + 6*x2 >= 0)
m.addConstr(6*x0 - 2*x1 >= 0)
m.addConstr(6*x0 - 3*x2 >= 0)
m.addConstr(15*x0 + 2*x1 <= 108)
m.addConstr(2*x1 + 13*x2 <= 89)
m.addConstr(15*x0 + 2*x1 + 13*x2 <= 43)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Dale:", x0.varValue)
    print("Hours worked by Bobby:", x1.varValue)
    print("Hours worked by Jean:", x2.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
