
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, name="x0")  # milligrams of vitamin B9
x1 = m.addVar(lb=0, name="x1")  # milligrams of potassium
x2 = m.addVar(lb=0, name="x2")  # milligrams of vitamin C
x3 = m.addVar(lb=0, name="x3")  # milligrams of vitamin B3
x4 = m.addVar(lb=0, name="x4")  # milligrams of vitamin B5


# Set objective function
obj = 8.97*x0*x1 + 2.75*x0*x2 + 2.67*x0*x3 + 3.21*x0*x4 + 9.65*x1**2 + 4.42*x1*x2 + 8.77*x1*x3 + 3.0*x1*x4 + 7.41*x2**2 + 7.77*x2*x3 + 8.72*x2*x4 + 8.83*x3**2 + 7.6*x3*x4 + 7.04*x4**2 + 3.39*x0 + 5.26*x1 + 5.3*x3 + 8.27*x4

m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.69*x0 + 0.25*x3 >= 47)
m.addConstr(0.07*x1**2 + 0.25*x3**2 >= 30)
m.addConstr(0.25*x3**2 + 0.9*x4**2 >= 23)
m.addConstr(0.1*x2**2 + 0.25*x3**2 >= 38)
m.addConstr(0.69*x0 + 0.1*x2 >= 27)
m.addConstr(0.07*x1 + 0.25*x3 + 0.9*x4 >= 66)
m.addConstr(0.07*x1 + 0.1*x2 + 0.25*x3 >= 66)
m.addConstr(0.07*x1 + 0.25*x3 + 0.9*x4 >= 52)
m.addConstr(0.07*x1 + 0.1*x2 + 0.25*x3 >= 52)
m.addConstr(0.03*x1 + 0.03*x2 >= 14)
m.addConstr(0.03*x1 + 0.02*x3 >= 11)
m.addConstr(0.27*x0 + 0.03*x1 >= 14)
m.addConstr(0.03*x2 + 0.02*x3 >= 25)
m.addConstr(0.27*x0**2 + 0.03*x2**2 >= 30)
m.addConstr(0.27*x0 + 0.02*x3 + 0.93*x4 >= 23)
m.addConstr(0.03*x1 + 0.03*x2 + 0.02*x3 >= 23)
m.addConstr(0.03*x2 + 0.02*x3 + 0.93*x4 >= 23)
m.addConstr(0.27*x0**2 + 0.02*x3**2 + 0.93*x4**2 >= 21)
m.addConstr(0.03*x1**2 + 0.03*x2**2 + 0.02*x3**2 >= 21)
m.addConstr(0.03*x2 + 0.02*x3 + 0.93*x4 >= 21)
m.addConstr(0.27*x0**2 + 0.02*x3**2 + 0.93*x4**2 >= 27)
m.addConstr(0.03*x1 + 0.03*x2 + 0.02*x3 >= 27)
m.addConstr(0.03*x2 + 0.02*x3 + 0.93*x4 >= 27)
m.addConstr(0.07*x1**2 + 0.9*x4**2 <= 292)
m.addConstr(0.69*x0**2 + 0.1*x2**2 <= 273)
m.addConstr(0.07*x1 + 0.25*x3 <= 142)
m.addConstr(0.69*x0**2 + 0.07*x1**2 <= 309)
m.addConstr(0.25*x3**2 + 0.9*x4**2 <= 332)
m.addConstr(0.1*x2 + 0.25*x3 + 0.9*x4 <= 155)
m.addConstr(0.69*x0 + 0.07*x1 + 0.1*x2 + 0.25*x3 + 0.9*x4 <= 155)
m.addConstr(0.03*x2 + 0.93*x4 <= 39)
m.addConstr(0.27*x0**2 + 0.02*x3**2 <= 125)
m.addConstr(0.27*x0**2 + 0.03*x2**2 <= 101)
m.addConstr(0.03*x1**2 + 0.93*x4**2 <= 38)
m.addConstr(0.27*x0 + 0.03*x1 + 0.02*x3 <= 59)
m.addConstr(0.27*x0**2 + 0.02*x3**2 + 0.93*x4**2 <= 87)
m.addConstr(0.03*x1 + 0.03*x2 + 0.93*x4 <= 117)
m.addConstr(0.27*x0 + 0.03*x1 + 0.03*x2 <= 75)
m.addConstr(0.27*x0**2 + 0.03*x1**2 + 0.93*x4**2 <= 64)
m.addConstr(0.27*x0 + 0.03*x1 + 0.03*x2 + 0.02*x3 + 0.93*x4 <= 64)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

