
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_cereal")
x1 = m.addVar(vtype=GRB.INTEGER, name="pickles")
x2 = m.addVar(vtype=GRB.INTEGER, name="protein_bars")

# Set objective function
m.setObjective(7*x0**2 + 4*x0*x1 + 3*x0*x2 + 9*x1**2 + 3*x1*x2 + 7*x2**2 + 2*x0 + 5*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x0 + 21*x1 + 19*x2 >= 59, "c1")
m.addConstr(4*x0**2 + 21*x1**2 >= 59, "c2")
m.addConstr(21*x0**2 + 10*x1**2 >= 73, "c3")
m.addConstr(10*x1 + 14*x2 >= 49, "c4")
m.addConstr(21*x0 + 10*x1 + 14*x2 >= 49, "c5")
m.addConstr(9*x0 - 3*x2 >= 0, "c6")
m.addConstr(4*x0 + 21*x1 <= 133, "c7")
m.addConstr(21*x0**2 + 10*x1**2 + 14*x2**2 <= 247, "c8")

# Resource Constraints
m.addConstr(4*x0 + 21*x1 + 19*x2 <= 195, "umami_limit")
m.addConstr(21*x0 + 10*x1 + 14*x2 <= 446, "cost_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bowls_of_cereal:', x0.x)
    print('pickles:', x1.x)
    print('protein_bars:', x2.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

