
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="bowls_of_cereal", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="pickles", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="protein_bars", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7*x0**2 + 4*x0*x1 + 3*x0*x2 + 9*x1**2 + 3*x1*x2 + 7*x2**2 + 2*x0 + 5*x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4*x0 <= 195, name="umami_index_cereal")
    model.addConstr(21*x0 <= 446, name="cost_cereal")
    model.addConstr(21*x1 <= 446, name="cost_pickles")
    model.addConstr(10*x1 <= 446, name="cost_pickles2")
    model.addConstr(19*x2 <= 446, name="umami_index_protein_bars")
    model.addConstr(14*x2 <= 446, name="cost_protein_bars")
    model.addConstr((4*x0)**2 + (21*x1)**2 >= 59, name="min_umami_index_cereal_pickles")
    model.addConstr(4*x0 + 21*x1 + 19*x2 >= 59, name="min_umami_index_all")
    model.addConstr((21*x0)**2 + (10*x1)**2 >= 73, name="min_cost_cereal_pickles")
    model.addConstr(10*x1 + 14*x2 >= 49, name="min_cost_pickles_protein_bars")
    model.addConstr(21*x0 + 10*x1 + 14*x2 >= 49, name="min_cost_all")
    model.addConstr(9*x0 - 3*x2 >= 0, name="cereal_protein_bars_constraint")
    model.addConstr(4*x0 + 21*x1 <= 133, name="max_umami_index_cereal_pickles")
    model.addConstr((21*x0)**2 + (10*x1)**2 + (14*x2)**2 <= 247, name="max_cost_all")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("bowls of cereal: ", x0.varValue)
        print("pickles: ", x1.varValue)
        print("protein bars: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
