
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    oreos = m.addVar(vtype=gp.GRB.INTEGER, name="oreos")
    peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
    cheeseburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")


    # Set objective function
    m.setObjective(4 * oreos + 5 * peanutbutter_sandwiches + 2 * cheeseburgers, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * peanutbutter_sandwiches + 3 * cheeseburgers >= 31, "cost_pb_cb")
    m.addConstr(5 * oreos + 3 * cheeseburgers >= 41, "cost_o_cb")
    m.addConstr(5 * oreos + 7 * peanutbutter_sandwiches <= 164, "cost_o_pb")
    m.addConstr(7 * peanutbutter_sandwiches + 3 * cheeseburgers <= 165, "cost_pb_cb_max")
    m.addConstr(5 * oreos + 7 * peanutbutter_sandwiches + 3 * cheeseburgers <= 176, "total_cost")
    m.addConstr(11 * peanutbutter_sandwiches + 8 * cheeseburgers <= 93, "tastiness_pb_cb")
    m.addConstr(4 * oreos + 11 * peanutbutter_sandwiches <= 79, "tastiness_o_pb")
    m.addConstr(4 * oreos + 8 * cheeseburgers <= 64, "tastiness_o_cb")
    m.addConstr(4 * oreos + 11 * peanutbutter_sandwiches + 8 * cheeseburgers <= 64, "total_tastiness")  # total tastiness
    m.addConstr(9 * peanutbutter_sandwiches + 1 * cheeseburgers <= 77, "iron_pb_cb")
    m.addConstr(11 * oreos + 9 * peanutbutter_sandwiches <= 83, "iron_o_pb")
    m.addConstr(11 * oreos + 9 * peanutbutter_sandwiches + 1 * cheeseburgers <= 83, "total_iron")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Oreos:', oreos.x)
        print('Peanutbutter Sandwiches:', peanutbutter_sandwiches.x)
        print('Cheeseburgers:', cheeseburgers.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
