
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='oreos', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='peanutbutter sandwiches')
    x2 = model.addVar(name='cheeseburgers')

    # Define the objective function
    model.setObjective(4*x0 + 5*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7*x1 + 3*x2 >= 31)
    model.addConstr(5*x0 + 3*x2 >= 41)
    model.addConstr(5*x0 + 7*x1 <= 164)
    model.addConstr(7*x1 + 3*x2 <= 165)
    model.addConstr(5*x0 + 7*x1 + 3*x2 <= 165)
    model.addConstr(11*x1 + 8*x2 <= 93)
    model.addConstr(4*x0 + 11*x1 <= 79)
    model.addConstr(4*x0 + 8*x2 <= 64)
    model.addConstr(4*x0 + 11*x1 + 8*x2 <= 64)
    model.addConstr(9*x1 + x2 <= 77)
    model.addConstr(11*x0 + 9*x1 <= 83)
    model.addConstr(11*x0 + 9*x1 + x2 <= 83)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('oreos: ', x0.varValue)
        print('peanutbutter sandwiches: ', x1.varValue)
        print('cheeseburgers: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
