
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Peggy", "Paul", "Jean", "Bobby", "George", "Laura"])


# Set objective
m.setObjective(9.66 * x[0] + 4.72 * x[1] + 6.94 * x[2] + 4.81 * x[3] + 2.15 * x[4] + 1.26 * x[5], gp.GRB.MINIMIZE)

# Resource and attribute data
resource_data = {
    'r0': {'x0': 10, 'x1': 20, 'x2': 4, 'x3': 7, 'x4': 23, 'x5': 5},
    'r1': {'x0': 5, 'x1': 5, 'x2': 4, 'x3': 13, 'x4': 1, 'x5': 23},
    'r2': {'x0': 18, 'x1': 13, 'x2': 23, 'x3': 3, 'x4': 10, 'x5': 10},
    'r3': {'x0': 8, 'x1': 26, 'x2': 8, 'x3': 3, 'x4': 4, 'x5': 18},
    'r4': {'x0': 16, 'x1': 16, 'x2': 13, 'x3': 3, 'x4': 19, 'x5': 22}
}


# Add constraints from the input
constraints_text = """
7 * x4 - 9 * x5 >= 0
-10 * x0 + 5 * x2 >= 0
5 * x1 - x2 - 10 * x4 >= 0
5 * x0 - 4 * x2 - 2 * x5 >= 0
-2 * x1 + 10 * x5 >= 0
10 * x3 + 5 * x5 >= 99
10 * x0 + 23 * x4 >= 86
4 * x2 + 5 * x5 >= 95
4 * x2 + 23 * x4 >= 110
23 * x4 + 5 * x5 >= 91
4 * x2 + 7 * x3 >= 81
10 * x0 + 7 * x3 >= 94
4 * x2 + 23 * x4 + 5 * x5 >= 118
10 * x0 + 4 * x2 + 5 * x5 >= 118
10 * x0 + 20 * x1 + 4 * x2 >= 118
10 * x0 + 4 * x2 + 23 * x4 >= 118
4 * x2 + 23 * x4 + 5 * x5 >= 97
10 * x0 + 4 * x2 + 5 * x5 >= 97
10 * x0 + 20 * x1 + 4 * x2 >= 97
10 * x0 + 4 * x2 + 23 * x4 >= 97
4 * x2 + 23 * x4 + 5 * x5 >= 113
10 * x0 + 4 * x2 + 5 * x5 >= 113
10 * x0 + 20 * x1 + 4 * x2 >= 113
10 * x0 + 4 * x2 + 23 * x4 >= 113
4 * x2 + 23 * x4 + 5 * x5 >= 103
10 * x0 + 4 * x2 + 5 * x5 >= 103
10 * x0 + 20 * x1 + 4 * x2 >= 103
10 * x0 + 4 * x2 + 23 * x4 >= 103
10 * x0 + 20 * x1 + 4 * x2 + 7 * x3 + 23 * x4 + 5 * x5 >= 103
4 * x2 + 23 * x5 >= 33
5 * x1 + x4 >= 34
5 * x1 + 4 * x2 >= 62
5 * x0 + 5 * x1 >= 58
4 * x2 + 13 * x3 >= 79
5 * x1 + 23 * x5 >= 81
5 * x0 + 5 * x1 + 4 * x2 + 13 * x3 + x4 + 23 * x5 >= 81
13 * x1 + 23 * x2 >= 129
18 * x0 + 23 * x2 >= 66
18 * x0 + 3 * x3 >= 46
23 * x2 + 3 * x3 >= 115
13 * x1 + 10 * x4 >= 96
10 * x0 + 23 * x4 <= 279
10 * x0 + 7 * x3 <= 467
20 * x1 + 7 * x3 <= 454
4 * x2 + 23 * x4 <= 160
7 * x3 + 5 * x5 <= 564
20 * x1 + 5 * x5 <= 653
20 * x1 + 4 * x2 <= 124
4 * x2 + 23 * x5 <= 451
13 * x3 + 23 * x5 <= 94
23 * x2 + 10 * x4 <= 525
3 * x3 + 10 * x5 <= 516
4 * x0 + 4 * x2 <= 341
5 * x0 + 13 * x3 <= 356
5 * x1 + x4 <= 291
5 * x1 + 13 * x3 <= 468
x4 + 23 * x5 <= 437
18 * x0 + 10 * x4 <= 169
10 * x4 + 10 * x5 <= 785
23 * x2 + 3 * x3 <= 588
13 * x1 + 10 * x4 <= 492
4 + 18 * x5 <= 131

"""
for constraint in constraints_text.strip().split('\n'):
    m.addConstr(eval(constraint))


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", m.status)

