
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define the variables
x1, x2, x3, x4, x5, x6 = m.addVars(6, name=['Peggy', 'Paul', 'Jean', 'Bobby', 'George', 'Laura'])

# Objective function: For demonstration purposes, let's minimize the sum of hours worked
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MINIMIZE)

# Constraints: Add each constraint from the problem description here
# Example constraint: hours worked by Peggy + hours worked by Paul >= 72
m.addConstr(x1 + x2 >= 72, name='MinimumHours')

# Solve the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
