
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["network_administrators", "honeypots", "automatic_alerts", "pen_testers", "intrusion_analysts", "SOC_operators"])


# Set objective function
m.setObjective(8*x[0] + 9*x[1] + 4*x[2] + 9*x[3] + 9*x[4] + 6*x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x[0] + 1*x[3] >= 12)
m.addConstr(5*x[2] + 7*x[5] >= 7)
m.addConstr(2*x[1] + 1*x[4] + 7*x[5] >= 14)

m.addConstr(6*x[0] + 6*x[2] + 2*x[4] >= 17)
m.addConstr(6*x[2] + 4*x[3] + 2*x[4] >= 17)
m.addConstr(6*x[0] + 5*x[1] + 2*x[5] >= 17)
m.addConstr(6*x[0] + 6*x[2] + 4*x[3] >= 17)

m.addConstr(6*x[0] + 6*x[2] + 2*x[4] >= 19)
m.addConstr(6*x[2] + 4*x[3] + 2*x[4] >= 19)
m.addConstr(6*x[0] + 5*x[1] + 2*x[5] >= 19)
m.addConstr(6*x[0] + 6*x[2] + 4*x[3] >= 19)

m.addConstr(6*x[0] + 6*x[2] + 2*x[4] >= 22)
m.addConstr(6*x[2] + 4*x[3] + 2*x[4] >= 22)
m.addConstr(6*x[0] + 5*x[1] + 2*x[5] >= 22)
m.addConstr(6*x[0] + 6*x[2] + 4*x[3] >= 22)


m.addConstr(2*x[1] + 5*x[2] <= 96)
m.addConstr(3*x[0] + 7*x[5] <= 59)
m.addConstr(3*x[0] + 2*x[1] <= 135)
m.addConstr(1*x[3] + 7*x[5] <= 94)
m.addConstr(5*x[2] + 1*x[3] <= 38)
m.addConstr(5*x[2] + 1*x[3] + 7*x[5] <= 118)
m.addConstr(3*x[0] + 5*x[2] + 1*x[3] <= 115)
m.addConstr(3*x[0] + 2*x[1] + 5*x[2] + 1*x[3] + 1*x[4] + 7*x[5] <= 115)


m.addConstr(6*x[2] + 2*x[4] <= 82)
m.addConstr(6*x[2] + 2*x[5] <= 82)
m.addConstr(5*x[1] + 6*x[2] <= 87)
m.addConstr(2*x[4] + 2*x[5] <= 65)
m.addConstr(6*x[0] + 4*x[3] <= 82)
m.addConstr(6*x[0] + 6*x[2] + 2*x[4] <= 81)
m.addConstr(6*x[0] + 6*x[2] + 4*x[3] <= 77)
m.addConstr(6*x[2] + 4*x[3] + 2*x[5] <= 66)
m.addConstr(6*x[0] + 5*x[1] + 4*x[3] <= 38)
m.addConstr(6*x[0] + 5*x[1] + 6*x[2] <= 45)
m.addConstr(5*x[1] + 6*x[2] + 2*x[5] <= 65)
m.addConstr(6*x[0] + 2*x[4] + 2*x[5] <= 124)
m.addConstr(6*x[0] + 5*x[1] + 2*x[4] <= 109)
m.addConstr(5*x[1] + 6*x[2] + 4*x[3] <= 109)
m.addConstr(5*x[1] + 4*x[3] + 2*x[5] <= 99)
m.addConstr(6*x[0] + 5*x[1] + 2*x[5] <= 68)
m.addConstr(6*x[2] + 2*x[4] + 2*x[5] <= 106)
m.addConstr(6*x[0] + 6*x[2] + 2*x[5] <= 29)
m.addConstr(6*x[0] + 4*x[3] + 2*x[4] <= 126)
m.addConstr(5*x[1] + 6*x[2] + 2*x[4] <= 123)
m.addConstr(6*x[0] + 5*x[1] + 6*x[2] + 4*x[3] + 2*x[4] + 2*x[5] <= 123)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

