
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="honeypots", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="automatic_alerts", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="SOC_operators", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x0 + 9*x1 + 4*x2 + 9*x3 + 9*x4 + 6*x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x0 + 2*x1 + 5*x2 + x3 + x4 + 7*x5 <= 135)
    model.addConstr(6*x0 + 5*x1 + 6*x2 + 4*x3 + 2*x4 + 2*x5 <= 137)
    model.addConstr(3*x0 + x3 >= 12)
    model.addConstr(5*x2 + 7*x5 >= 7)
    model.addConstr(2*x1 + x4 + 7*x5 >= 14)
    model.addConstr(6*x0 + 6*x2 + 2*x4 >= 17)
    model.addConstr(6*x2 + 4*x3 + 2*x4 >= 17)
    model.addConstr(6*x0 + 5*x1 + 2*x5 >= 17)
    model.addConstr(6*x0 + 6*x2 + 4*x3 >= 17)
    model.addConstr(6*x0 + 6*x2 + 2*x4 >= 19)
    model.addConstr(6*x2 + 4*x3 + 2*x4 >= 19)
    model.addConstr(6*x0 + 5*x1 + 2*x5 >= 19)
    model.addConstr(6*x0 + 6*x2 + 4*x3 >= 22)
    model.addConstr(6*x0 + 6*x2 + 2*x4 >= 22)
    model.addConstr(6*x2 + 4*x3 + 2*x4 >= 22)
    model.addConstr(6*x0 + 5*x1 + 2*x5 >= 22)
    model.addConstr(2*x1 + 5*x2 <= 96)
    model.addConstr(3*x0 + 7*x5 <= 59)
    model.addConstr(3*x0 + 2*x1 <= 135)
    model.addConstr(x3 + 7*x5 <= 94)
    model.addConstr(5*x2 + x3 <= 38)
    model.addConstr(5*x2 + x3 + 7*x5 <= 118)
    model.addConstr(3*x0 + 5*x2 + x3 <= 115)
    model.addConstr(3*x0 + 2*x1 + 5*x2 + x3 + x4 + 7*x5 <= 115)
    model.addConstr(6*x2 + 2*x4 <= 82)
    model.addConstr(6*x2 + 2*x5 <= 82)
    model.addConstr(5*x1 + 6*x2 <= 87)
    model.addConstr(2*x4 + 2*x5 <= 65)
    model.addConstr(6*x0 + 4*x3 <= 82)
    model.addConstr(6*x0 + 6*x2 + 2*x4 <= 81)
    model.addConstr(6*x0 + 6*x2 + 4*x3 <= 77)
    model.addConstr(6*x2 + 4*x3 + 2*x5 <= 66)
    model.addConstr(6*x0 + 5*x1 + 4*x3 <= 38)
    model.addConstr(6*x0 + 5*x1 + 6*x2 <= 45)
    model.addConstr(5*x1 + 6*x2 + 2*x5 <= 65)
    model.addConstr(6*x0 + 2*x4 + 2*x5 <= 124)
    model.addConstr(6*x0 + 5*x1 + 2*x4 <= 109)
    model.addConstr(5*x1 + 6*x2 + 4*x3 <= 109)
    model.addConstr(5*x1 + 4*x3 + 2*x5 <= 99)
    model.addConstr(6*x0 + 5*x1 + 2*x5 <= 68)
    model.addConstr(6*x2 + 2*x4 + 2*x5 <= 106)
    model.addConstr(6*x0 + 6*x2 + 2*x5 <= 29)
    model.addConstr(6*x0 + 4*x3 + 2*x4 <= 126)
    model.addConstr(5*x1 + 6*x2 + 2*x4 <= 123)
    model.addConstr(6*x0 + 5*x1 + 6*x2 + 4*x3 + 2*x4 + 2*x5 <= 123)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("network administrators: ", x0.varValue)
        print("honeypots: ", x1.varValue)
        print("automatic alerts: ", x2.varValue)
        print("pen testers: ", x3.varValue)
        print("intrusion analysts: ", x4.varValue)
        print("SOC operators: ", x5.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
