
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(lb=0, name="steaks")
pickles = m.addVar(lb=0, name="pickles")
strawberries = m.addVar(lb=0, name="strawberries")
pasta = m.addVar(lb=0, name="bowls_of_pasta")


# Set objective function
m.setObjective(7.17 * steaks + 5.44 * pickles + 5.24 * strawberries + 3.15 * pasta, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * steaks + 13 * pickles + 2 * strawberries + 2 * pasta <= 234, "dollar_cost")  # Total cost
m.addConstr(2 * steaks + 2 * strawberries >= 39, "steak_strawberry_cost")
m.addConstr(2 * steaks + 2 * pasta >= 46, "steak_pasta_cost")
m.addConstr(2 * steaks + 13 * pickles >= 40, "steak_pickle_cost")
m.addConstr(2 * steaks + 13 * pickles + 2 * strawberries + 2 * pasta >= 40, "total_cost_min")
m.addConstr(3 * steaks - 10 * pickles >= 0, "steak_pickle_ratio")
m.addConstr(2 * steaks + 13 * pickles + 2 * pasta <= 128, "steak_pickle_pasta_cost")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Steaks:', steaks.x)
    print('Pickles:', pickles.x)
    print('Strawberries:', strawberries.x)
    print('Bowls of pasta:', pasta.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

