
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_pasta")

# Define the objective function
m.setObjective(7.17*x1 + 5.44*x2 + 5.24*x3 + 3.15*x4, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x3 >= 39, name="steaks_and_strawberries")
m.addConstr(2*x1 + 2*x4 >= 46, name="steaks_and_pasta")
m.addConstr(2*x1 + 13*x2 >= 40, name="steaks_and_pickles")
m.addConstr(2*x1 + 13*x2 + 2*x3 + 2*x4 >= 40, name="all_items_together")
m.addConstr(3*x1 - 10*x2 >= 0, name="steaks_vs_pickles")
m.addConstr(2*x1 + 13*x2 + 2*x4 <= 128, name="budget_for_steaks_pickles_pasta")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for var in m.getVars():
        print(f"{var.VarName}: {var.x}")
else:
    print("No optimal solution found")
