
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="steaks", lb=0)
    x2 = model.addVar(name="pickles", lb=0)
    x3 = model.addVar(name="strawberries", lb=0)
    x4 = model.addVar(name="bowls of pasta", lb=0)

    # Define the objective function
    model.setObjective(7.17 * x1 + 5.44 * x2 + 5.24 * x3 + 3.15 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x1 + 2 * x3 >= 39)
    model.addConstr(2 * x1 + 2 * x4 >= 46)
    model.addConstr(2 * x1 + 13 * x2 >= 40)
    model.addConstr(2 * x1 + 13 * x2 + 2 * x3 + 2 * x4 >= 40)
    model.addConstr(3 * x1 - 10 * x2 >= 0)
    model.addConstr(2 * x1 + 13 * x2 + 2 * x4 <= 128)
    model.addConstr(2 * x1 + 13 * x2 + 2 * x3 + 2 * x4 <= 234)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Steaks: {x1.varValue}")
        print(f"Pickles: {x2.varValue}")
        print(f"Strawberries: {x3.varValue}")
        print(f"Bowls of pasta: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
