
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="x0", lb=0)  # milligrams of vitamin B7
    x1 = m.addVar(name="x1", lb=0)  # grams of carbohydrates
    x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin B5


    # Set objective function
    m.setObjective(8.64*x0**2 + 6.6*x1**2 + 7.34*x1*x2 + 2.91*x1 + 2.27*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12*x0 + 6*x1 + 15*x2 <= 157, "c0")
    m.addConstr(10*x0 + 15*x1 + 14*x2 <= 77, "c1")
    m.addConstr(6*x1 + 15*x2 <= 108, "c2")
    m.addConstr(12*x0**2 + 6*x1**2 <= 138, "c3")
    m.addConstr(12*x0 + 15*x2 <= 117, "c4")
    m.addConstr(12*x0**2 + 6*x1**2 + 15*x2**2 <= 78, "c5")
    m.addConstr(12*x0 + 6*x1 + 15*x2 <= 78, "c6")
    m.addConstr(15*x1 + 14*x2 <= 61, "c7")
    m.addConstr(10*x0**2 + 14*x2**2 <= 30, "c8")
    m.addConstr(10*x0**2 + 15*x1**2 + 14*x2**2 <= 26, "c9")
    m.addConstr(10*x0 + 15*x1 + 14*x2 <= 26, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
