
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")
    
    # Objective function
    model.setObjective(8.64*x0**2 + 6.6*x1**2 + 7.34*x1*x2 + 2.91*x1 + 2.27*x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(x0 <= 157/12)
    model.addConstr(10*x0 <= 77)
    model.addConstr(6*x1 <= 157)
    model.addConstr(15*x1 <= 77)
    model.addConstr(15*x2 <= 157)
    model.addConstr(14*x2 <= 77)
    model.addConstr(6*x1 + 15*x2 <= 108)
    model.addConstr(144*x0**2 + 36*x1**2 <= 138)
    model.addConstr(12*x0 + 15*x2 <= 117)
    model.addConstr(144*x0**2 + 36*x1**2 + 225*x2**2 <= 78)
    model.addConstr(12*x0 + 6*x1 + 15*x2 <= 78)
    model.addConstr(15*x1 + 14*x2 <= 61)
    model.addConstr(100*x0**2 + 196*x2**2 <= 30)
    model.addConstr(100*x0**2 + 225*x1**2 + 196*x2**2 <= 26)
    model.addConstr(10*x0 + 15*x1 + 14*x2 <= 26)
    
    # Solve the model
    model.optimize()
    
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
