
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_vitamin_B7")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_vitamin_B9")


    # Set objective function
    m.setObjective(4.43 * x0 + 3.0 * x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11 * x0 + 14 * x1 >= 49, "c0")
    m.addConstr(12 * x0 + 16 * x1 >= 61, "c1")
    m.addConstr(12 * x0 + 4 * x1 >= 47, "c2")
    m.addConstr(-5 * x0 + 2 * x1 >= 0, "c3")
    m.addConstr(11 * x0 + 14 * x1 <= 130, "c4")
    m.addConstr(12 * x0 + 16 * x1 <= 118, "c5")
    m.addConstr(12 * x0 + 4 * x1 <= 129, "c6")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

