
from gurobipy import *

# Create a model
m = Model("Vitamin_Optimization")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B9")

# Set the objective function
m.setObjective(4.43*x1 + 3.0*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x1 + 14*x2 >= 49, "energy_stability_index")
m.addConstr(12*x1 + 16*x2 >= 61, "kidney_support_index")
m.addConstr(12*x1 + 4*x2 >= 47, "cognitive_performance_index")
m.addConstr(-5*x1 + 2*x2 >= 0, "specific_constraint")
m.addConstr(11*x1 + 14*x2 <= 130, "max_energy_stability_index")
m.addConstr(12*x1 + 16*x2 <= 118, "max_kidney_support_index")
m.addConstr(12*x1 + 4*x2 <= 129, "max_cognitive_performance_index")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B7: {x1.x}")
    print(f"Milligrams of Vitamin B9: {x2.x}")
else:
    print("No optimal solution found")

