
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams of vitamin B7", lb=0)
    x2 = model.addVar(name="milligrams of vitamin B9", lb=0)

    # Objective function
    model.setObjective(4.43 * x1 + 3.0 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11 * x1 <= 146)
    model.addConstr(12 * x1 <= 162)
    model.addConstr(12 * x1 <= 139)
    model.addConstr(14 * x2 <= 146)
    model.addConstr(16 * x2 <= 162)
    model.addConstr(4 * x2 <= 139)
    model.addConstr(11 * x1 + 14 * x2 >= 49)
    model.addConstr(12 * x1 + 16 * x2 >= 61)
    model.addConstr(12 * x1 + 4 * x2 >= 47)
    model.addConstr(-5 * x1 + 2 * x2 >= 0)
    model.addConstr(11 * x1 + 14 * x2 <= 130)
    model.addConstr(12 * x1 + 16 * x2 <= 118)
    model.addConstr(12 * x1 + 4 * x2 <= 129)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B7: {x1.varValue}")
        print(f"Milligrams of vitamin B9: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
