
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of potassium
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of protein
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B4
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # milligrams of vitamin B9


# Set objective function
m.setObjective(8*x0 + 8*x1 + 5*x2 + 6*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 6*x1 + 4*x2 + 14*x3 <= 224)
m.addConstr(11*x0 + 2*x1 + 14*x2 + 7*x3 <= 220)
m.addConstr(3*x0 + 12*x1 + 15*x2 + 8*x3 <= 215)
m.addConstr(2*x0 + 10*x1 + 6*x2 + 6*x3 <= 104)
m.addConstr(4*x2 + 14*x3 >= 29)
m.addConstr(2*x1 + 14*x2 >= 51)
m.addConstr(11*x0 + 7*x3 >= 22)
m.addConstr(11*x0 + 2*x1 >= 30)
m.addConstr(2*x1 + 7*x3 >= 33)
m.addConstr(11*x0 + 14*x2 + 7*x3 >= 42)
m.addConstr(3*x0 + 12*x1 + 15*x2 >= 49)
m.addConstr(3*x0 + 12*x1 + 8*x3 >= 49)
m.addConstr(3*x0 + 15*x2 + 8*x3 >= 49)

# ... (rest of the constraints from the JSON)

m.addConstr(2*x0 + 6*x2 <= 59)
m.addConstr(2*x0 + 10*x1 <= 63)
m.addConstr(6*x2 + 6*x3 <= 72)
m.addConstr(10*x1 + 6*x2 <= 66)
m.addConstr(2*x0 + 10*x1 + 6*x2 + 6*x3 <= 66)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

