
import gurobi

def optimize_problem():
    try:
        # Create a new model
        model = gurobi.Model()

        # Define variables
        x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
        x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")

        # Objective function
        model.setObjective(4.16 * x1**2 + 8.88 * x1 * x2 + 8.4 * x2**2 + 1.6 * x1 + 8.51 * x2, gurobi.GRB.MAXIMIZE)

        # Constraints
        model.addConstr(x1 == 12, name="c1")
        model.addConstr(x1 == 8, name="c2")
        model.addConstr(x1 == 2, name="c3")
        model.addConstr(x1 == 5, name="c4")
        model.addConstr(x2 == 5, name="c5")
        model.addConstr(x2 == 10, name="c6")
        model.addConstr(x2 == 12, name="c7")
        model.addConstr(x2 == 8, name="c8")
        model.addConstr(x1 + x2 >= 15, name="c9")
        model.addConstr(x1 + x2 >= 26, name="c10")
        model.addConstr(x1 + x2 >= 9, name="c11")
        model.addConstr(x1**2 + x2**2 >= 33, name="c12")
        model.addConstr(-x1**2 + x2**2 >= 0, name="c13")
        model.addConstr(x1 + x2 <= 34, name="c14")
        model.addConstr(x1 + x2 <= 45, name="c15")
        model.addConstr(x1 + x2 <= 27, name="c16")
        model.addConstr(x1 + x2 <= 72, name="c17")

        # Optimize
        model.optimize()

        # Print solution
        if model.status == gurobi.GRB.Status.OPTIMAL:
            print("Objective: ", model.objVal)
            print("x1: ", x1.varValue)
            print("x2: ", x2.varValue)
        else:
            print("No solution found")

    except gurobi.GUROBI_ERROR as e:
        print("Gurobi Error: ", e)

optimize_problem()
