
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(7, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Bill", "Ringo", "John", "Hank", "Jean", "Peggy", "Laura"])


# Set objective function
m.setObjective(1*x[0] + 2*x[1] + 6*x[2] + 1*x[3] + 9*x[4] + 8*x[5] + 3*x[6], gp.GRB.MINIMIZE)

# Add constraints

# Resource constraints
computer_competence = {0: 3, 1: 2, 2: 12, 3: 7, 4: 9, 5: 12, 6: 1}
likelihood_to_quit = {0: 12, 1: 10, 2: 7, 3: 13, 4: 9, 5: 14, 6: 14}


m.addConstr(12*x[2] + 1*x[6] >= 65)
m.addConstr(3*x[0] + 9*x[4] >= 34)
m.addConstr(3*x[0] + 12*x[2] >= 36)
m.addConstr(12*x[2] + 7*x[3] >= 66)
m.addConstr(2*x[1] + 7*x[3] >= 40)
m.addConstr(12*x[2] + 12*x[5] >= 43)
m.addConstr(2*x[1] + 12*x[5] >= 57)
m.addConstr(3*x[0] + 7*x[3] >= 43)
m.addConstr(7*x[3] + 12*x[5] >= 39)
m.addConstr(2*x[1] + 1*x[6] >= 71)
m.addConstr(9*x[4] + 1*x[6] >= 64)
m.addConstr(3*x[0] + 2*x[1] >= 59)
m.addConstr(3*x[0] + 1*x[6] >= 60)
m.addConstr(12*x[2] + 9*x[4] >= 47)
m.addConstr(2*x[1] + 9*x[4] >= 71)
m.addConstr(12*x[2] + 9*x[4] + 1*x[6] >= 58)
m.addConstr(2*x[1] + 12*x[5] + 1*x[6] >= 58)
m.addConstr(12*x[2] + 9*x[4] + 1*x[6] >= 72)
m.addConstr(2*x[1] + 12*x[5] + 1*x[6] >= 72)
m.addConstr(3*x[0] + 2*x[1] + 12*x[2] + 7*x[3] + 9*x[4] + 12*x[5] + 1*x[6] >= 72)
m.addConstr(13*x[3] + 9*x[4] >= 34)
m.addConstr(13*x[3] + 14*x[6] >= 39)
m.addConstr(7*x[2] + 9*x[4] >= 25)
m.addConstr(9*x[4] + 14*x[5] >= 25)
m.addConstr(14*x[5] + 14*x[6] >= 32)
m.addConstr(10*x[1] + 14*x[5] >= 26)
m.addConstr(7*x[2] + 14*x[6] >= 39)

m.addConstr(3*x[0] + 9*x[4] + 1*x[6] <= 356)
m.addConstr(3*x[0] + 12*x[2] + 9*x[4] <= 254)
m.addConstr(12*x[2] + 12*x[5] + 1*x[6] <= 500)
m.addConstr(2*x[1] + 9*x[4] + 1*x[6] <= 420)
m.addConstr(3*x[0] + 7*x[3] + 12*x[5] <= 125)
m.addConstr(7*x[3] + 9*x[4] + 1*x[6] <= 297)
m.addConstr(3*x[0] + 2*x[1] + 9*x[4] <= 254)
m.addConstr(12*x[2] + 7*x[3] + 12*x[5] <= 287)
m.addConstr(2*x[1] + 12*x[2] + 7*x[3] <= 123)
m.addConstr(12*x[0] + 7*x[2] <= 238)
m.addConstr(12*x[0] + 14*x[5] <= 69)
m.addConstr(7*x[2] + 14*x[6] <= 137)
m.addConstr(9*x[4] + 14*x[6] <= 242)
m.addConstr(13*x[3] + 14*x[6] <= 184)
m.addConstr(10*x[1] + 7*x[2] + 9*x[4] <= 199)


m.addConstr(-3*x[1] + 7*x[4] >= 0)
m.addConstr(-6*x[2] + 9*x[5] >= 0)
m.addConstr(7*x[3] - 2*x[6] >= 0)
m.addConstr(9*x[2] - 5*x[3] >= 0)



for i in range(23, 41):
    m.addConstr(likelihood_to_quit[0]*x[0] + likelihood_to_quit[1]*x[1] + likelihood_to_quit[2]*x[2] >= i)
    m.addConstr(likelihood_to_quit[0]*x[0] + likelihood_to_quit[1]*x[1] + likelihood_to_quit[5]*x[5] >= i)
    m.addConstr(likelihood_to_quit[1]*x[1] + likelihood_to_quit[4]*x[4] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[2]*x[2] + likelihood_to_quit[4]*x[4] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[0]*x[0] + likelihood_to_quit[2]*x[2] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[3]*x[3] + likelihood_to_quit[4]*x[4] + likelihood_to_quit[5]*x[5] >= i)
    m.addConstr(likelihood_to_quit[1]*x[1] + likelihood_to_quit[2]*x[2] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[0]*x[0] + likelihood_to_quit[1]*x[1] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[0]*x[0] + likelihood_to_quit[1]*x[1] + likelihood_to_quit[4]*x[4] >= i)
    m.addConstr(likelihood_to_quit[1]*x[1] + likelihood_to_quit[2]*x[2] + likelihood_to_quit[3]*x[3] >= i)
    m.addConstr(likelihood_to_quit[2]*x[2] + likelihood_to_quit[3]*x[3] + likelihood_to_quit[4]*x[4] >= i)
    m.addConstr(likelihood_to_quit[2]*x[2] + likelihood_to_quit[3]*x[3] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[0]*x[0] + likelihood_to_quit[4]*x[4] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[0]*x[0] + likelihood_to_quit[5]*x[5] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[1]*x[1] + likelihood_to_quit[3]*x[3] + likelihood_to_quit[6]*x[6] >= i)
    m.addConstr(likelihood_to_quit[1]*x[1] + likelihood_to_quit[4]*x[4] + likelihood_to_quit[5]*x[5] >= i)
    m.addConstr(likelihood_to_quit[1]*x[1] + likelihood_to_quit[3]*x[3] + likelihood_to_quit[5]*x[5] >= i)
    m.addConstr(likelihood_to_quit[1]*x[1] + likelihood_to_quit[3]*x[3] + likelihood_to_quit[4]*x[4] >= i)
m.addConstr(sum(likelihood_to_quit[i] * x[i] for i in range(7)) >= 40)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

