
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x = m.addVars(7, name="x", lb=0)

# Set the variable names for clarity
x[0].setAttr("Name", "hours worked by Bill")
x[1].setAttr("Name", "hours worked by Ringo")
x[2].setAttr("Name", "hours worked by John")
x[3].setAttr("Name", "hours worked by Hank")
x[4].setAttr("Name", "hours worked by Jean")
x[5].setAttr("Name", "hours worked by Peggy")
x[6].setAttr("Name", "hours worked by Laura")

# Objective function
m.setObjective(1 * x[0] + 2 * x[1] + 6 * x[2] + 1 * x[3] + 9 * x[4] + 8 * x[5] + 3 * x[6], gp.GRB.MINIMIZE)

# Constraints
# Computer competence rating constraints
m.addConstr(3 * x[0] + 2 * x[1] + 12 * x[2] + 7 * x[3] + 9 * x[4] + 12 * x[5] + 1 * x[6] <= 504)
m.addConstr(12 * x[0] + 10 * x[1] + 7 * x[2] + 13 * x[3] + 9 * x[4] + 14 * x[5] + 14 * x[6] <= 280)

# ... add all other constraints ...

# Add specific constraints
m.addConstr(3 * x[0] >= 0)
m.addConstr(12 * x[0] <= 280)

m.addConstr(2 * x[1] >= 0)
m.addConstr(10 * x[1] <= 280)

m.addConstr(12 * x[2] >= 0)
m.addConstr(7 * x[2] <= 280)

m.addConstr(7 * x[3] >= 0)
m.addConstr(13 * x[3] <= 280)

m.addConstr(9 * x[4] >= 0)
m.addConstr(9 * x[4] <= 280)

m.addConstr(12 * x[5] >= 0)
m.addConstr(14 * x[5] <= 280)

m.addConstr(1 * x[6] >= 0)
m.addConstr(14 * x[6] <= 280)

# The total combined computer competence rating from hours worked by John, and hours worked by Laura should be at minimum 65.
m.addConstr(12 * x[2] + 1 * x[6] >= 65)

# The total combined computer competence rating from hours worked by Bill, and hours worked by Jean must be 34 or more.
m.addConstr(3 * x[0] + 9 * x[4] >= 34)

# ... add all other constraints ...

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    for i in range(7):
        print(f"x[{i}] = {x[i].varValue}")
else:
    print("No solution found")
