
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Laura")  # Laura's hours
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Ringo")  # Ringo's hours, integer

    # Set objective function
    obj = 3*x0**2 + 2*x0*x1 + 4*x1**2 + 7*x0 + 8*x1
    model.setObjective(obj, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15*x0 + 6*x1 >= 32, "c1")
    model.addConstr(18*x0 + 20*x1 >= 31, "c2")
    model.addConstr(7*x0**2 + 3*x1**2 >= 53, "c3")
    model.addConstr(7*x0**2 + 25*x1**2 >= 12, "c4")
    model.addConstr(28*x0 + 10*x1 >= 22, "c5")
    model.addConstr(-7*x0 + 3*x1 >= 0, "c6")
    model.addConstr(15*x0 + 6*x1 <= 111, "c7")
    model.addConstr(18*x0 + 20*x1 <= 60, "c8")
    model.addConstr(7*x0**2 + 3*x1**2 <= 59, "c9")
    model.addConstr(7*x0 + 25*x1 <= 43, "c10")  # Corrected constraint
    model.addConstr(28*x0**2 + 10*x1**2 <= 63, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
