
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Laura
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Ringo

    # Objective function
    model.setObjective(3*x0**2 + 2*x0*x1 + 4*x1**2 + 7*x0 + 8*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15*x0 + 6*x1 >= 32)
    model.addConstr(18*x0 + 20*x1 >= 31)
    model.addConstr(7*x0**2 + 3*x1**2 >= 53)
    model.addConstr(7*x0**2 + 25*x1**2 >= 12)
    model.addConstr(28*x0 + 10*x1 >= 22)
    model.addConstr(-7*x0 + 3*x1 >= 0)
    model.addConstr(15*x0 + 6*x1 <= 111)
    model.addConstr(18*x0 + 20*x1 <= 60)
    model.addConstr(7*x0**2 + 3*x1**2 <= 59)
    model.addConstr(7*x0 + 25*x1 <= 43)
    model.addConstr(28*x0**2 + 10*x1**2 <= 63)
    model.addConstr(28*x0 + 10*x1 <= 63)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
