
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_k = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_k")
vitamin_d = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
carbohydrates = m.addVar(vtype=gp.GRB.INTEGER, name="carbohydrates")
vitamin_b12 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
vitamin_b6 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b6")


# Set objective function
m.setObjective(9.13 * vitamin_k + 9.38 * vitamin_d + 1.34 * carbohydrates + 1.33 * vitamin_b12 + 5.88 * calcium + 4.86 * vitamin_b6, gp.GRB.MINIMIZE)

# Add constraints based on the provided resources/attributes
resources = {
    'r0': {'upper_bound': 477, 'x0': 14, 'x1': 15, 'x2': 10, 'x3': 17, 'x4': 20, 'x5': 1},
    'r1': {'upper_bound': 197, 'x0': 16, 'x1': 12, 'x2': 12, 'x3': 17, 'x4': 8, 'x5': 11},
    'r2': {'upper_bound': 233, 'x0': 14, 'x1': 11, 'x2': 13, 'x3': 12, 'x4': 5, 'x5': 16},
    'r3': {'upper_bound': 421, 'x0': 7, 'x1': 18, 'x2': 17, 'x3': 23, 'x4': 22, 'x5': 14}
}


# Add other constraints from the problem description (simplified and deduplicated)
m.addConstr(14 * vitamin_k + 10 * carbohydrates >= 72)
m.addConstr(10 * carbohydrates + 20 * calcium >= 49)
m.addConstr(10 * carbohydrates + 17 * vitamin_b12 >= 65)
m.addConstr(15 * vitamin_d + 10 * carbohydrates >= 68)
m.addConstr(15 * vitamin_d + 17 * vitamin_b12 >= 44)
m.addConstr(17 * vitamin_b12 + 20 * calcium >= 40)
m.addConstr(14 * vitamin_k + 20 * calcium >= 79)
m.addConstr(17 * vitamin_b12 + 1 * vitamin_b6 >= 32)
m.addConstr(17 * vitamin_b12 + 20 * calcium + 1 * vitamin_b6 >= 62)
m.addConstr(14 * vitamin_k + 20 * calcium + 1 * vitamin_b6 >= 67)
m.addConstr(14 * vitamin_k + 15 * vitamin_d + 10 * carbohydrates + 17 * vitamin_b12 + 20 * calcium + 1 * vitamin_b6 >= 67)


m.addConstr(-2 * carbohydrates + 2 * vitamin_b6 >= 0)
m.addConstr(2 * vitamin_d - carbohydrates >= 0)
m.addConstr(-10 * vitamin_d + 6 * calcium >= 0)
m.addConstr(20 * calcium + 1 * vitamin_b6 <= 150)



# Optimize model
m.optimize()

# Print results if a solution is found
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

