
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by Mary
x1 = m.addVar(name="x1", vtype=gp.GRB.CONTINUOUS)  # hours worked by John
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Ringo
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # hours worked by George
x4 = m.addVar(name="x4", vtype=gp.GRB.CONTINUOUS)  # hours worked by Bobby
x5 = m.addVar(name="x5", vtype=gp.GRB.CONTINUOUS)  # hours worked by Laura

# Define the objective function
m.setObjective(7 * x0**2 + 4 * x0 * x3 + 4 * x0 * x4 + x0 * x5 + 6 * x1 * x2 + 5 * x2**2 + 7 * x2 * x4 + 3 * x2 * x5 + 5 * x3**2 + 8 * x3 * x4 + 6 * x4 * x5 + 2 * x5**2 + 6 * x0 + 8 * x2 + 6 * x3 + 6 * x4 + 9 * x5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * x0 >= 2)
m.addConstr(2 * x0 >= 2)
m.addConstr(5 * x0 >= 5)
m.addConstr(5 * x0 >= 5)

m.addConstr(4 * x1 >= 4)
m.addConstr(6 * x1 >= 6)
m.addConstr(3 * x1 >= 3)
m.addConstr(x1 >= 1)

m.addConstr(x2 >= 1)
m.addConstr(7 * x2 >= 7)
m.addConstr(2 * x2 >= 2)
m.addConstr(4 * x2 >= 4)

m.addConstr(6 * x3 >= 6)
m.addConstr(4 * x3 >= 4)
m.addConstr(7 * x3 >= 7)
m.addConstr(6 * x3 >= 6)

m.addConstr(6 * x4 >= 6)
m.addConstr(4 * x4 >= 4)
m.addConstr(7 * x4 >= 7)
m.addConstr(5 * x4 >= 5)

m.addConstr(2 * x5 >= 2)
m.addConstr(x5 >= 1)
m.addConstr(3 * x5 >= 3)
m.addConstr(4 * x5 >= 4)

m.addConstr(2 * x0**2 + 4 * x1**2 >= 6)
m.addConstr(x1 + x5 >= 9)
m.addConstr(x4**2 + x5**2 >= 9)
m.addConstr(x1 + x4 >= 14)
m.addConstr(x0**2 + x3**2 >= 12)
m.addConstr(x1**2 + x2**2 >= 5)
m.addConstr(x0**2 + x2**2 + x5**2 >= 13)
m.addConstr(x3 + x4 + x5 >= 13)
m.addConstr(x0**2 + x1**2 + x3**2 >= 13)
m.addConstr(x2 + x3 + x5 >= 13)
m.addConstr(x0 + x3 + x4 >= 13)
m.addConstr(x1 + x2 + x3 >= 13)
m.addConstr(x0 + x3 + x5 >= 13)
m.addConstr(x1 + x2 + x4 >= 13)
m.addConstr(x0 + x2 + x4 >= 14)
m.addConstr(x0 + x2 + x5 >= 12)
m.addConstr(x3**2 + x4**2 + x5**2 >= 12)
m.addConstr(x1 + x3 + x5 >= 12)
m.addConstr(x0**2 + x1**2 + x3**2 >= 12)
m.addConstr(x2 + x3 + x5 >= 12)
m.addConstr(x0 + x2 + x4 >= 12)
m.addConstr(x1**2 + x2**2 + x3**2 >= 12)
m.addConstr(x0**2 + x3**2 + x5**2 >= 12)
m.addConstr(x1 + x2 + x4 >= 12)
m.addConstr(x0**2 + x2**2 + x4**2 >= 12)
m.addConstr(x0**2 + x2**2 + x5**2 >= 14)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("The model is infeasible.")
