
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")


# Set objective function
m.setObjective(1.65 * x0 + 6.21 * x1 + 3.6 * x2 + 5.69 * x3 + 8.9 * x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * x0 + 6 * x1 + 5 * x2 + 9 * x3 + 9 * x4 <= 116, "c0")
m.addConstr(8 * x0 + 10 * x1 + 10 * x2 + 2 * x3 + 12 * x4 <= 441, "c1")
m.addConstr(7 * x0 + 6 * x1 + 10 * x2 + 10 * x3 + 12 * x4 <= 161, "c2")
m.addConstr(6 * x1 + 9 * x4 >= 10, "c3")
m.addConstr(13 * x0 + 9 * x3 >= 22, "c4")
m.addConstr(5 * x2 + 9 * x3 >= 18, "c5")
m.addConstr(5 * x2 + 9 * x4 >= 20, "c6")
m.addConstr(6 * x1 + 5 * x2 + 9 * x4 >= 13, "c7")
m.addConstr(6 * x1 + 5 * x2 + 9 * x3 >= 13, "c8")
m.addConstr(13 * x0 + 6 * x1 + 5 * x2 + 9 * x3 + 9 * x4 >= 13, "c9")
m.addConstr(8 * x0 + 10 * x2 >= 77, "c10")
# ... (rest of the constraints)

#Removed redundant constraints

m.addConstr(10 * x3 + 12 * x4 >= 19, "c58")
m.addConstr(7 * x0 + 10 * x2 >= 22, "c59")
m.addConstr(7 * x0 + 6 * x1 + 10 * x2 + 10 * x3 + 12 * x4 >= 22, "c60")
m.addConstr(3 * x2 - 6 * x4 >= 0, "c61")
m.addConstr(13 * x0 + 6 * x1 + 5 * x2 <= 114, "c62")
m.addConstr(13 * x0 + 6 * x1 + 9 * x3 <= 108, "c63")
m.addConstr(6 * x1 + 5 * x2 + 9 * x3 <= 111, "c64")
m.addConstr(13 * x0 + 10 * x2 + 9 * x4 <= 103, "c65")
m.addConstr(10 * x1 + 12 * x4 <= 353, "c66")
m.addConstr(10 * x1 + 2 * x3 + 12 * x4 <= 215, "c67")
m.addConstr(10 * x2 + 2 * x3 + 12 * x4 <= 93, "c68")
m.addConstr(10 * x1 + 10 * x2 + 2 * x3 <= 257, "c69")
m.addConstr(10 * x3 + 12 * x4 <= 56, "c70")
m.addConstr(6 * x1 + 10 * x2 + 12 * x4 <= 62, "c71")
m.addConstr(7 * x0 + 6 * x1 + 12 * x4 <= 99, "c72")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

