
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Resource_Allocation")

    # Create variables
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    paul_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="paul_hours")


    # Set objective function
    model.setObjective(9 * laura_hours + 6 * paul_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * laura_hours + 20 * paul_hours >= 45, "org_score_min")
    model.addConstr(22 * laura_hours + 4 * paul_hours >= 16, "paperwork_min")
    model.addConstr(4 * laura_hours + 23 * paul_hours >= 29, "quality_min")
    model.addConstr(5 * laura_hours - 5 * paul_hours >= 0, "laura_paul_relation")
    model.addConstr(15 * laura_hours + 20 * paul_hours <= 130, "org_score_max")
    model.addConstr(22 * laura_hours + 4 * paul_hours <= 87, "paperwork_max")
    model.addConstr(4 * laura_hours + 23 * paul_hours <= 102, "quality_max")


    # Optimize model
    model.optimize()

    # Print results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Laura's hours: {laura_hours.x}")
        print(f"Paul's hours: {paul_hours.x}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
