
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours_worked_by_Paul")

# Set objective function
m.setObjective(9*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 20*x2 >= 45, "organization_score_constraint")
m.addConstr(22*x1 + 4*x2 >= 16, "paperwork_competence_rating_constraint")
m.addConstr(4*x1 + 23*x2 >= 29, "work_quality_rating_constraint")
m.addConstr(5*x1 - 5*x2 >= 0, "hours_worked_by_Laura_and_Paul_constraint")
m.addConstr(15*x1 + 20*x2 <= 130, "upper_bound_organization_score_constraint")
m.addConstr(22*x1 + 4*x2 <= 87, "upper_bound_paperwork_competence_rating_constraint")
m.addConstr(4*x1 + 23*x2 <= 102, "upper_bound_work_quality_rating_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
else:
    print("No optimal solution found")
