
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Laura", lb=0, ub=None)
    x2 = model.addVar(name="hours_worked_by_Paul", lb=0, integer=True)

    # Define the objective function
    model.setObjective(9 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(15 * x1 + 20 * x2 >= 45)
    model.addConstr(22 * x1 + 4 * x2 >= 16)
    model.addConstr(4 * x1 + 23 * x2 >= 29)
    model.addConstr(5 * x1 - 5 * x2 >= 0)
    model.addConstr(15 * x1 + 20 * x2 <= 130)
    model.addConstr(22 * x1 + 4 * x2 <= 87)
    model.addConstr(4 * x1 + 23 * x2 <= 102)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {x1.varValue}")
        print(f"Hours worked by Paul: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
