
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["x0", "x1", "x2", "x3", "x4", "x5"])


# Set objective function
m.setObjective(1.02 * x[0] + 2.39 * x[1] + 7.81 * x[2] + 6.67 * x[3] + 4.32 * x[4] + 1.19 * x[5], gp.GRB.MAXIMIZE)

# Add resource constraints
resource_data = {
    'r0': {'upper_bound': 398, 'coefficients': [19, 16, 11, 24, 28, 11]},
    'r1': {'upper_bound': 722, 'coefficients': [12, 25, 26, 3, 2, 17]},
    'r2': {'upper_bound': 570, 'coefficients': [31, 30, 14, 9, 10, 12]},
    'r3': {'upper_bound': 718, 'coefficients': [24, 14, 28, 4, 6, 27]},
    'r4': {'upper_bound': 960, 'coefficients': [30, 22, 7, 16, 1, 22]}
}

for resource, data in resource_data.items():
    m.addConstr(gp.quicksum(data['coefficients'][i] * x[i] for i in range(6)) <= data['upper_bound'], name=resource)


# Add other constraints from the problem description (truncated for brevity - add all constraints from JSON)
m.addConstr(19 * x[0] + 16 * x[1] >= 45)
# ... Add all other constraints from the JSON


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for i in range(6):
        print(f"x{i}: {x[i].x}")
    print("Objective value:", m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

