
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="blue_highlighters")
x2 = m.addVar(vtype=GRB.INTEGER, name="blue_pens")
x3 = m.addVar(vtype=GRB.INTEGER, name="yellow_highlighters")
x4 = m.addVar(vtype=GRB.INTEGER, name="color_printers")
x5 = m.addVar(vtype=GRB.INTEGER, name="rubber_bands")
x6 = m.addVar(vtype=GRB.INTEGER, name="manila_envelopes")

# Objective function
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MINIMIZE)

# Constraints
m.addConstr(64*x1 + 45*x2 >= 137, "Constraint_1")
m.addConstr(12*x3 + 21*x4 <= 329, "Constraint_2")

# Other constraints need to be added similarly...

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

