
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B4
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin C
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B9


    # Set objective function
    m.setObjective(3*x0 + 4*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2.57*x0 + 3.29*x1 >= 28)
    m.addConstr(3.29*x1 + 3.63*x2 >= 54)
    m.addConstr(2.57*x0 + 3.29*x1 + 3.63*x2 >= 39)
    m.addConstr(2.81*x0 + 0.14*x1 >= 75)
    m.addConstr(2.81*x0 + 0.97*x2 >= 66)
    m.addConstr(2.81*x0 + 0.14*x1 + 0.97*x2 >= 66)
    m.addConstr(1.89*x0 + 0.17*x2 >= 62)
    m.addConstr(1.89*x0 + 0.42*x1 + 0.17*x2 >= 62)
    m.addConstr(0.17*x1 + 3.03*x2 >= 39)
    m.addConstr(1.12*x0 + 3.03*x2 >= 41)
    m.addConstr(1.12*x0 + 0.17*x1 + 3.03*x2 >= 41)
    m.addConstr(2.49*x0 + 3.07*x1 >= 34)
    m.addConstr(2.49*x0 + 3.07*x1 + 2.49*x2 >= 34)
    m.addConstr(2.57*x0 + 3.63*x2 <= 174)
    m.addConstr(2.57*x0 + 3.29*x1 <= 180)
    m.addConstr(1.89*x0 + 0.42*x1 <= 89)
    m.addConstr(1.89*x0 + 0.17*x2 <= 147)
    m.addConstr(0.42*x1 + 0.17*x2 <= 63)
    m.addConstr(1.12*x0 + 0.17*x1 <= 97)

    # Resource Constraints (upper bounds)
    m.addConstr(2.57*x0 <= 220)
    m.addConstr(2.81*x0 <= 376)
    m.addConstr(1.89*x0 <= 186)
    m.addConstr(1.12*x0 <= 195)
    m.addConstr(2.49*x0 <= 267)
    m.addConstr(3.29*x1 <= 220)
    m.addConstr(0.14*x1 <= 376)
    m.addConstr(0.42*x1 <= 186)
    m.addConstr(0.17*x1 <= 195)
    m.addConstr(3.07*x1 <= 267)
    m.addConstr(3.63*x2 <= 220)
    m.addConstr(0.97*x2 <= 376)
    m.addConstr(0.17*x2 <= 186)
    m.addConstr(3.03*x2 <= 195)
    m.addConstr(2.49*x2 <= 267)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
