
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams of vitamin B4", lb=0)
x2 = m.addVar(name="milligrams of vitamin C", lb=0)
x3 = m.addVar(name="milligrams of vitamin B9", lb=0)

# Define the objective function
m.setObjective(3*x1 + 4*x2 + 5*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.57*x1 + 3.29*x2 >= 28)
m.addConstr(3.29*x2 + 3.63*x3 >= 54)
m.addConstr(2.57*x1 + 3.29*x2 + 3.63*x3 >= 39)
m.addConstr(2.81*x1 + 0.14*x2 >= 75)
m.addConstr(2.81*x1 + 0.97*x3 >= 66)
m.addConstr(2.81*x1 + 0.14*x2 + 0.97*x3 >= 66)
m.addConstr(1.89*x1 + 0.17*x3 >= 62)
m.addConstr(1.89*x1 + 0.42*x2 + 0.17*x3 >= 62)
m.addConstr(0.17*x2 + 3.03*x3 >= 39)
m.addConstr(1.12*x1 + 3.03*x3 >= 41)
m.addConstr(1.12*x1 + 0.17*x2 + 3.03*x3 >= 41)
m.addConstr(2.49*x1 + 3.07*x2 >= 34)
m.addConstr(2.49*x1 + 3.07*x2 + 2.49*x3 >= 34)
m.addConstr(2.57*x1 + 3.29*x2 <= 180)
m.addConstr(2.57*x1 + 3.63*x3 <= 174)
m.addConstr(1.89*x1 + 0.42*x2 <= 89)
m.addConstr(1.89*x1 + 0.17*x3 <= 147)
m.addConstr(0.42*x2 + 0.17*x3 <= 63)
m.addConstr(1.12*x1 + 0.17*x2 <= 97)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of vitamin B4: ", x1.varValue)
    print("Milligrams of vitamin C: ", x2.varValue)
    print("Milligrams of vitamin B9: ", x3.varValue)
else:
    print("The problem is infeasible")
