
import gurobipy as gp

# Create a new model
m = gp.Model("Employee_Scheduling")

# Create variables
employees = ['Peggy', 'George', 'Bobby', 'John', 'Hank', 'Dale']
hours = m.addVars(employees, lb=0, name="hours")

# Set objective function
objective = 1 * hours['Peggy'] + 9 * hours['George'] + 7 * hours['Bobby'] + 9 * hours['John'] + 9 * hours['Hank'] + 7 * hours['Dale']
m.setObjective(objective, gp.GRB.MAXIMIZE)


# Likelihood to quit index
likelihood_to_quit = {'Peggy': 3, 'George': 1, 'Bobby': 13, 'John': 7, 'Hank': 12, 'Dale': 4}

# Add constraints based on the provided data
m.addConstr(likelihood_to_quit['George'] * hours['George'] + likelihood_to_quit['Bobby'] * hours['Bobby'] <= 106)
m.addConstr(likelihood_to_quit['Peggy'] * hours['Peggy'] + likelihood_to_quit['George'] * hours['George'] <= 75)
m.addConstr(likelihood_to_quit['Peggy'] * hours['Peggy'] + likelihood_to_quit['Dale'] * hours['Dale'] <= 159)
m.addConstr(likelihood_to_quit['John'] * hours['John'] + likelihood_to_quit['Hank'] * hours['Hank'] <= 86)
m.addConstr(likelihood_to_quit['Peggy'] * hours['Peggy'] + likelihood_to_quit['John'] * hours['John'] <= 110)


# ... (Add all other constraints similarly using the provided data)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for employee in employees:
        print(f"{employee}: {hours[employee].x}")
    print("Objective value:", m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

