
from gurobipy import *

# Create a new model
m = Model("Workforce_Optimization")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Peggy")
x2 = m.addVar(name="hours_worked_by_George")
x3 = m.addVar(name="hours_worked_by_Bobby")
x4 = m.addVar(name="hours_worked_by_John")
x5 = m.addVar(name="hours_worked_by_Hank")
x6 = m.addVar(name="hours_worked_by_Dale")

# Set the objective function (for demonstration, let's minimize total hours)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MINIMIZE)

# Add constraints
# For example:
m.addConstr(x1 + x2 <= 268)  # Example constraint

# ... add all other constraints here

# Optimize the model
m.optimize()

# Print out the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
