
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Peggy")
x1 = m.addVar(lb=0, name="hours_worked_by_George")
x2 = m.addVar(lb=0, name="hours_worked_by_Bobby")
x3 = m.addVar(lb=0, name="hours_worked_by_John")
x4 = m.addVar(lb=0, name="hours_worked_by_Hank")
x5 = m.addVar(lb=0, name="hours_worked_by_Dale")

# Objective function
m.setObjective(1 * x0 + 9 * x1 + 7 * x2 + 9 * x3 + 9 * x4 + 7 * x5, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(3 * x0 >= 3)
m.addConstr(1 * x1 >= 1)
m.addConstr(13 * x2 >= 13)
m.addConstr(7 * x3 >= 7)
m.addConstr(12 * x4 >= 12)
m.addConstr(4 * x5 >= 4)
m.addConstr(1 * x0 >= 1)
m.addConstr(4 * x1 >= 4)
m.addConstr(5 * x2 >= 5)
m.addConstr(7 * x3 >= 7)
m.addConstr(13 * x4 >= 13)
m.addConstr(7 * x5 >= 7)
m.addConstr(6 * x0 >= 6)
m.addConstr(11 * x1 >= 11)
m.addConstr(2 * x2 >= 2)
m.addConstr(10 * x3 >= 10)
m.addConstr(7 * x4 >= 7)
m.addConstr(1 * x5 >= 1)
m.addConstr(8 * x0 >= 8)
m.addConstr(13 * x1 >= 13)
m.addConstr(2 * x2 >= 2)
m.addConstr(2 * x3 >= 2)
m.addConstr(12 * x4 >= 12)
m.addConstr(1 * x5 >= 1)
m.addConstr(1 * x0 >= 1)
m.addConstr(10 * x1 >= 10)
m.addConstr(14 * x2 >= 14)
m.addConstr(6 * x3 >= 6)
m.addConstr(12 * x4 >= 12)
m.addConstr(2 * x5 >= 2)

# Additional constraints
m.addConstr(3 * x0 + 1 * x1 >= 21)
m.addConstr(1 * x1 + 12 * x4 >= 26)
m.addConstr(3 * x0 + 12 * x4 + 4 * x5 >= 18)
m.addConstr(3 * x0 + 1 * x1 + 13 * x2 >= 18)
m.addConstr(3 * x0 + 7 * x3 + 4 * x5 >= 18)
m.addConstr(1 * x1 + 12 * x4 + 4 * x5 >= 18)
m.addConstr(1 * x1 + 2 * x2 + 12 * x4 >= 18)
m.addConstr(1 * x1 + 7 * x3 + 4 * x5 >= 18)
m.addConstr(7 * x3 + 12 * x4 + 4 * x5 >= 18)
m.addConstr(1 * x1 + 7 * x3 + 12 * x4 >= 18)
m.addConstr(3 * x0 + 12 * x4 + 4 * x5 >= 29)
m.addConstr(3 * x0 + 1 * x1 + 13 * x2 >= 29)
m.addConstr(3 * x0 + 7 * x3 + 4 * x5 >= 29)
m.addConstr(1 * x1 + 12 * x4 + 4 * x5 >= 29)
m.addConstr(1 * x1 + 2 * x2 + 12 * x4 >= 29)
m.addConstr(1 * x1 + 7 * x3 + 4 * x5 >= 29)
m.addConstr(7 * x3 + 12 * x4 + 4 * x5 >= 29)
m.addConstr(1 * x1 + 7 * x3 + 12 * x4 >= 29)

# ... (rest of the constraints)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Peggy: ", x0.varValue)
    print("Hours worked by George: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
    print("Hours worked by John: ", x3.varValue)
    print("Hours worked by Hank: ", x4.varValue)
    print("Hours worked by Dale: ", x5.varValue)
else:
    print("No optimal solution found")
