
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="decorative cabbages")
x1 = m.addVar(vtype=GRB.INTEGER, name="apple trees")
x2 = m.addVar(vtype=GRB.INTEGER, name="daisies")
x3 = m.addVar(vtype=GRB.INTEGER, name="verbenas")


# Set objective function
m.setObjective(6*x0**2 + 6*x0*x1 + 5*x0*x2 + 7*x1**2 + 5*x1*x2 + 8*x1*x3 + 2*x3**2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 3*x2 <= 126)
m.addConstr(6*x1 + 3*x2 <= 92)
m.addConstr(4*x0 + 21*x3 <= 91)
m.addConstr(6*x1 + 3*x2 + 21*x3 <= 262)
m.addConstr(4*x0 + 6*x1 + 3*x2 + 21*x3 <= 262)
m.addConstr(4*x0**2 + 3*x2**2 >= 45)
m.addConstr(6*x1 + 3*x2 >= 42)
m.addConstr(6*x1**2 + 3*x2**2 + 21*x3**2 >= 70)
m.addConstr(9*x0 + 14*x1 >= 45)
m.addConstr(20*x2 + 24*x3 >= 68)
m.addConstr(14*x1 + 20*x2 >= 48)
m.addConstr(14*x1**2 + 24*x3**2 >= 76)
m.addConstr(9*x0 + 24*x3 >= 72)
m.addConstr(14*x1 + 24*x3 <= 301)
m.addConstr(9*x0 + 14*x1 <= 299)
m.addConstr(20*x2 + 24*x3 <= 206)
m.addConstr(14*x1**2 + 20*x2**2 + 24*x3**2 <= 138)
m.addConstr(9*x0 + 14*x1 + 20*x2 + 24*x3 <= 138)
m.addConstr(20*x0 + x2 >= 78)
m.addConstr(20*x0**2 + 2*x3**2 >= 76)
m.addConstr(5*x1 + 2*x3 >= 78)
m.addConstr(x2 + 2*x3 <= 187)
m.addConstr(20*x0 + 5*x1 <= 202)
m.addConstr(20*x0 + x2 <= 306)
m.addConstr(5*x1**2 + x2**2 <= 219)
m.addConstr(20*x0 + 2*x3 <= 117)
m.addConstr(5*x1**2 + x2**2 + 2*x3**2 <= 129)
m.addConstr(20*x0 + x2 + 2*x3 <= 305)
m.addConstr(20*x0 + 5*x1 + 2*x3 <= 125)
m.addConstr(20*x0 + 5*x1 + x2 + 2*x3 <= 125)


# Resource constraints
m.addConstr(4 * x0 <= 323)
m.addConstr(9 * x0 <= 346)
m.addConstr(20 * x0 <= 328)
m.addConstr(6 * x1 <= 323)
m.addConstr(14 * x1 <= 346)
m.addConstr(5 * x1 <= 328)
m.addConstr(3 * x2 <= 323)
m.addConstr(20 * x2 <= 346)
m.addConstr(1 * x2 <= 328)
m.addConstr(21 * x3 <= 323)
m.addConstr(24 * x3 <= 346)
m.addConstr(2 * x3 <= 328)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

