
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="decorative_cabbages", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="apple_trees", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="daisies", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="verbenas", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6 * x0 ** 2 + 6 * x0 * x1 + 5 * x0 * x2 + 7 * x1 ** 2 + 5 * x1 * x2 + 8 * x1 * x3 + 2 * x3 ** 2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(4 * x0 <= 323)
m.addConstr(9 * x0 <= 346)
m.addConstr(20 * x0 <= 328)
m.addConstr(6 * x1 <= 323)
m.addConstr(14 * x1 <= 346)
m.addConstr(5 * x1 <= 328)
m.addConstr(3 * x2 <= 323)
m.addConstr(20 * x2 <= 346)
m.addConstr(x2 <= 328)
m.addConstr(21 * x3 <= 323)
m.addConstr(24 * x3 <= 346)
m.addConstr(2 * x3 <= 328)
m.addConstr(x0 ** 2 + x2 ** 2 >= 45)
m.addConstr(x1 + x2 >= 42)
m.addConstr(x1 ** 2 + x2 ** 2 + x3 ** 2 >= 70)
m.addConstr(9 * x0 + 14 * x1 >= 45)
m.addConstr(20 * x2 + 24 * x3 >= 68)
m.addConstr(14 * x1 + 20 * x2 >= 48)
m.addConstr(14 ** 2 * x1 ** 2 + 24 ** 2 * x3 ** 2 >= 76)
m.addConstr(9 * x0 + 24 * x3 >= 72)
m.addConstr(20 * x0 + x2 >= 78)
m.addConstr(20 ** 2 * x0 ** 2 + 2 ** 2 * x3 ** 2 >= 76)
m.addConstr(5 * x1 + 2 * x3 >= 78)
m.addConstr(4 * x0 + 3 * x2 <= 126)
m.addConstr(6 * x1 + 3 * x2 <= 92)
m.addConstr(4 * x0 + 21 * x3 <= 91)
m.addConstr(6 * x1 + 3 * x2 + 21 * x3 <= 262)
m.addConstr(4 * x0 + 6 * x1 + 3 * x2 + 21 * x3 <= 262)
m.addConstr(14 * x1 + 24 * x3 <= 301)
m.addConstr(9 * x0 + 14 * x1 <= 299)
m.addConstr(20 * x2 + 24 * x3 <= 206)
m.addConstr(14 ** 2 * x1 ** 2 + 20 ** 2 * x2 ** 2 + 24 ** 2 * x3 ** 2 <= 138)
m.addConstr(9 * x0 + 14 * x1 + 20 * x2 + 24 * x3 <= 138)
m.addConstr(x2 + 2 * x3 <= 187)
m.addConstr(20 * x0 + 5 * x1 <= 202)
m.addConstr(20 * x0 + x2 <= 306)
m.addConstr(5 ** 2 * x1 ** 2 + 1 ** 2 * x2 ** 2 <= 219)
m.addConstr(20 * x0 + 2 * x3 <= 117)
m.addConstr(5 ** 2 * x1 ** 2 + 1 ** 2 * x2 ** 2 + 2 ** 2 * x3 ** 2 <= 129)
m.addConstr(20 * x0 + x2 + 2 * x3 <= 305)
m.addConstr(20 * x0 + 5 * x1 + 2 * x3 <= 125)
m.addConstr(20 * x0 + 5 * x1 + x2 + 2 * x3 <= 125)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Decorative cabbages: ", x0.varValue)
    print("Apple trees: ", x1.varValue)
    print("Daisies: ", x2.varValue)
    print("Verbenas: ", x3.varValue)
else:
    print("The model is infeasible")
