
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Bill")
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours worked by Jean")


    # Set objective function
    m.setObjective(1.22 * x0 + 7.59 * x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12.44 * x0 + 6.97 * x1 >= 23, "computer_competence_min")
    m.addConstr(1.12 * x0 + 0.5 * x1 >= 59, "likelihood_to_quit_min")
    m.addConstr(10.33 * x0 + 9.44 * x1 >= 36, "work_quality_min")
    m.addConstr(1 * x0 - 5 * x1 >= 0, "bill_jean_relation")
    m.addConstr(12.44 * x0 + 6.97 * x1 <= 53, "computer_competence_max")
    m.addConstr(1.12 * x0 + 0.5 * x1 <= 90, "likelihood_to_quit_max")
    m.addConstr(10.33 * x0 + 9.44 * x1 <= 96, "work_quality_max")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
