
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables
x0 = model.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")
x1 = model.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Set the objective function
model.setObjective(1.22*x0 + 7.59*x1, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12.44*x0 + 6.97*x1 >= 23, "computer_competence_rating")
model.addConstr(1.12*x0 + 0.5*x1 >= 59, "likelihood_to_quit_index_min")
model.addConstr(10.33*x0 + 9.44*x1 >= 36, "work_quality_rating_min")
model.addConstr(x0 - 5*x1 >= 0, "hours_worked_constraint")
model.addConstr(12.44*x0 + 6.97*x1 <= 53, "computer_competence_rating_max")
model.addConstr(1.12*x0 + 0.5*x1 <= 90, "likelihood_to_quit_index_max")
model.addConstr(10.33*x0 + 9.44*x1 <= 96, "work_quality_rating_max")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {x0.x}")
    print(f"Hours worked by Jean: {x1.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found")
