
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Bill", lb=0)  # Assuming non-negative hours
    x1 = model.addVar(name="hours_worked_by_Jean", lb=0, integrality=gurobi.GRB.INTEGER)  # Integer constraint

    # Define the objective function
    model.setObjective(1.22*x0 + 7.59*x1, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12.44*x0 + 6.97*x1 >= 23)
    model.addConstr(1.12*x0 + 0.5*x1 >= 59)
    model.addConstr(10.33*x0 + 9.44*x1 >= 36)
    model.addConstr(x0 - 5*x1 >= 0)
    model.addConstr(12.44*x0 + 6.97*x1 <= 53)
    model.addConstr(1.12*x0 + 0.5*x1 <= 90)
    model.addConstr(10.33*x0 + 9.44*x1 <= 96)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x0.varValue}")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
