
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = {}
var_names = ['artillery batteries', 'logistics companies', 'air defense batteries', 'signal platoons', 'water purification units']
for i in range(len(var_names)):
    x[i] = m.addVar(vtype=gp.GRB.INTEGER, name=var_names[i])


# Set objective function
m.setObjective(4*x[0] + 1*x[1] + 5*x[2] + 9*x[3] + 9*x[4], gp.GRB.MINIMIZE)

# Resource and attribute data
resource_data = {
    'r0': {'upper_bound': 83, 'x0': 5, 'x1': 11, 'x2': 12, 'x3': 7, 'x4': 2},
    'r1': {'upper_bound': 163, 'x0': 9, 'x1': 10, 'x2': 2, 'x3': 9, 'x4': 5},
    'r2': {'upper_bound': 148, 'x0': 6, 'x1': 9, 'x2': 6, 'x3': 16, 'x4': 6},
    'r3': {'upper_bound': 345, 'x0': 12, 'x1': 12, 'x2': 14, 'x3': 14, 'x4': 11}
}

# Add resource constraints
m.addConstr(sum([resource_data['r0'][f'x{i}'] * x[i] for i in range(5)]) <= resource_data['r0']['upper_bound'], "r0_upper")
m.addConstr(sum([resource_data['r1'][f'x{i}'] * x[i] for i in range(5)]) <= resource_data['r1']['upper_bound'], "r1_upper")
m.addConstr(sum([resource_data['r2'][f'x{i}'] * x[i] for i in range(5)]) <= resource_data['r2']['upper_bound'], "r2_upper")
m.addConstr(sum([resource_data['r3'][f'x{i}'] * x[i] for i in range(5)]) <= resource_data['r3']['upper_bound'], "r3_upper")


# Add other constraints from the problem description (these were manually translated)
# ... (All the constraints from the JSON "constraints" field should be added here)

# Example:
m.addConstr(12*x[2] + 2*x[4] >= 15)
# ... (add all other constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

