
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="artillery_batteries")
x1 = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
x3 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
x4 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")

# Objective function
m.setObjective(4*x0 + x1 + 5*x2 + 9*x3 + 9*x4, GRB.MINIMIZE)

# Add constraints (example)
m.addConstr(4*x0 + 3*x1 + 5*x2 + 7*x3 + 2*x4 >= 100, "Offensive_capability")
m.addConstr(10*x0 + 8*x1 + 6*x2 + 9*x3 + 5*x4 <= 500, "Logistics_footprint")

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(v.varName, v.x)

print("Obj:", m.objVal)
