
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
x1 = m.addVar(name='x1', lb=0, ub=None)  # hours worked by Bobby
x2 = m.addVar(name='x2', lb=0, ub=None)  # hours worked by Hank
x3 = m.addVar(name='x3', lb=0, ub=None)  # hours worked by Mary

# Define the objective function
m.setObjective(6.1*x0 + 8.29*x1 + 4.21*x2 + 2.36*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 <= 210)
m.addConstr(3*x0 <= 106)
m.addConstr(4*x0 <= 112)
m.addConstr(2*x0 <= 54)
m.addConstr(8*x1 <= 210)
m.addConstr(6*x1 <= 106)
m.addConstr(10*x1 <= 112)
m.addConstr(8*x1 <= 54)
m.addConstr(7*x2 <= 210)
m.addConstr(9*x2 <= 106)
m.addConstr(3*x2 <= 112)
m.addConstr(8*x2 <= 54)
m.addConstr(3*x3 <= 210)
m.addConstr(4*x3 <= 106)
m.addConstr(7*x3 <= 112)
m.addConstr(11*x3 <= 54)
m.addConstr(11*x0 + 8*x1 + 7*x2 >= 39)
m.addConstr(11*x0 + 8*x1 + 3*x3 >= 39)
m.addConstr(11*x0 + 8*x1 + 7*x2 >= 47)
m.addConstr(11*x0 + 8*x1 + 3*x3 >= 47)
m.addConstr(3*x0 + 4*x3 >= 8)
m.addConstr(9*x2 + 4*x3 >= 15)
m.addConstr(6*x1 + 9*x2 >= 18)
m.addConstr(3*x0 + 6*x1 + 4*x3 >= 21)
m.addConstr(3*x2 + 7*x3 >= 20)
m.addConstr(10*x1 + 7*x3 >= 11)
m.addConstr(4*x0 + 3*x2 >= 25)
m.addConstr(10*x1 + 3*x2 >= 21)
m.addConstr(4*x0 + 7*x3 >= 28)
m.addConstr(4*x0 + 3*x2 + 7*x3 >= 20)
m.addConstr(2*x0 + 8*x2 >= 6)
m.addConstr(11*x0 + 3*x3 <= 195)
m.addConstr(11*x0 + 7*x2 <= 169)
m.addConstr(11*x0 + 8*x1 <= 72)
m.addConstr(8*x1 + 7*x2 <= 128)
m.addConstr(11*x0 + 8*x1 + 3*x3 <= 74)
m.addConstr(11*x0 + 8*x1 + 7*x2 <= 193)
m.addConstr(11*x0 + 8*x1 + 7*x2 + 3*x3 <= 193)
m.addConstr(3*x0 + 9*x2 <= 57)
m.addConstr(3*x0 + 6*x1 <= 103)
m.addConstr(3*x0 + 6*x1 + 9*x2 + 4*x3 <= 103)
m.addConstr(4*x0 + 3*x2 <= 87)
m.addConstr(10*x1 + 7*x3 <= 106)
m.addConstr(3*x2 + 7*x3 <= 45)
m.addConstr(4*x0 + 10*x1 + 3*x2 <= 79)
m.addConstr(10*x1 + 3*x2 + 7*x3 <= 73)
m.addConstr(4*x0 + 10*x1 + 7*x3 <= 43)
m.addConstr(4*x0 + 10*x1 + 3*x2 + 7*x3 <= 43)
m.addConstr(8*x2 + 11*x3 <= 46)
m.addConstr(2*x0 + 11*x3 <= 21)
m.addConstr(8*x1 + 8*x2 + 11*x3 <= 24)
m.addConstr(2*x0 + 8*x1 + 8*x2 + 11*x3 <= 24)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No solution found')
