
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
ramen = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ramen")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
corn = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn")
sashimi = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sashimi")


# Set objective function
m.setObjective(5.58 * bananas + 7.86 * ramen + 7.31 * hamburgers + 4.54 * corn + 7.58 * sashimi, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * ramen + 12 * sashimi >= 51)
m.addConstr(6 * bananas + 24 * corn >= 69)
m.addConstr(6 * bananas + 8 * hamburgers >= 61)
m.addConstr(8 * hamburgers + 12 * sashimi >= 86)
m.addConstr(6 * bananas + 11 * ramen + 8 * hamburgers + 24 * corn + 12 * sashimi >= 86)
m.addConstr(25 * bananas + 7 * hamburgers >= 81)
m.addConstr(2 * ramen + 1 * sashimi >= 72)
m.addConstr(2 * ramen + 7 * hamburgers >= 83)
m.addConstr(9 * corn + 1 * sashimi >= 54)
m.addConstr(7 * hamburgers + 1 * sashimi >= 52)
m.addConstr(2 * ramen + 9 * corn >= 103)
m.addConstr(7 * hamburgers + 9 * corn >= 93)

# ... (rest of the constraints from the JSON "constraints" field)

m.addConstr(6 * bananas + 11 * ramen + 8 * hamburgers + 24 * corn + 12 * sashimi <= 474)
m.addConstr(25 * bananas + 2 * ramen + 7 * hamburgers + 9 * corn + 1 * sashimi <= 584)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

